/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'jquerymobile', 'core/utilities/authentication', 'hbs!modules/navigation/exitNavigationPopup' ],
    function (Portal, Backbone, Marionette, $, jqm, authentication, template) {
    return Backbone.Marionette.ItemView.extend({
        model: new Backbone.Model(),
        tagName: 'div',
        id: "portal-exit-popup",
        attributes: {
            'data-role': 'popup',
            'data-theme': 'b',
            'data-transition': 'fade',
            'data-positionTo': 'window',
            'data-dismissible': 'true',
            'data-shadow': 'true',
            'data-overlay-theme': 'a'
        },
        template: template,
        events : {
            "click #logout-btn": "logout"
        },
        initialize : function (options) {
            var self = this,
                location = window.location,
                prodPath = location.origin,
                devPath = location.protocol + '//' + location.hostname + ':8080', //Given services are running in tomcat
                path = prodPath,
                launchpadPath = '/launchpad';
            
            if (location.hostname === 'localhost' && location.port !== '8080'){
                path = devPath;
            }
            this.launchpadPath = path + launchpadPath;

            Portal.commands.setHandler("open-portal-exit", self.openExit, self);

            Portal.vent.on('close:popups', self.closeExit, self);
        },
        onRender: function () {
            this.$el.find('#launchpad-btn').get(0).setAttribute('href', this.launchpadPath);
            this.$el.popup();
        },
        onClose: function() {
            Portal.vent.off('close:popups');
            this.stopListening();
            this.off();
        },
        openExit: function () {
            this.render();
            this.$el.popup('open');
        },
        closeExit: function() {
           $('#' + this.id).popup('close');
        },
        logout: function(e) {
            e.preventDefault();
            var logoutUrl = Portal.resources().get('logout').get('href');
            authentication.gotoLogoutWithRedirect(logoutUrl);
        }
    });
});